
use "C:\Users\Natasha Sarin\Dropbox\Harvard\Research\Banks\International Data March 2016\merged_vol_implied_vol__marketvols_20160314.dta", clear
capture drop crisis
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015

gen implied_minus_market = implied_vol - market_implied_vol 
gen implied_div_market = implied_vol/market_implied_vol 
gen vol_minus_market = vol-market_vol
gen vol_div_market = vol/market_vol

replace stock_price = . if stock_price == 0 
replace beta = . if beta == 0 
replace book_value_ps = . if book_value_ps == 0 
replace implied_vol = . if implied_vol == 0 
replace cds_spread = . if cds_spread == 0 
replace ptb = . if ptb == 0 
replace vol = . if vol == 0 
replace market_vol = . if market_vol == 0 
replace market_implied_vol = . if market_implied_vol == 0 


**** compute country averages 

capture drop test_year 
by country crisis, sort: egen mean_beta_c = mean(beta) 
by country crisis, sort: egen mean_vol_c = mean(vol)
by country crisis, sort: egen mean_vol_minus_market_c = mean(vol_minus_market)
by country crisis, sort: egen mean_vol_div_market_c = mean(vol_div_market)
by country crisis, sort: egen mean_implied_vol_c = mean(implied_vol)
by country crisis, sort: egen mean_implied_vol_minus_market_c = mean(implied_minus_market)
by country crisis, sort: egen mean_implied_vol_div_market_c = mean(implied_div_market)
by country crisis, sort: egen mean_cds_c = mean(cds_spread)
by country crisis, sort: egen mean_ptb_c = mean(ptb)


capture drop test_year

by crisis country, sort: gen test_year = _n
replace test_year = 0 if test_year != 1
br country crisis year mean_beta_c mean_vol_c mean_vol_minus_market_c mean_vol_div_market_c mean_implied_vol_c mean_implied_vol_minus_market_c mean_implied_vol_div_market_c mean_cds_c mean_ptb_c if test_year == 1 & crisis != . 
br country crisis year mean_ptb_c if test_year == 1 & crisis != . 

**** now we want country mean and median for pre and post-crisis period 
by crisis, sort: egen beta_mean = mean(beta)
by crisis, sort: egen beta_median = median(beta)
by crisis, sort: egen vol_mean = mean(vol)
by crisis, sort: egen vol_median = median(vol)
by crisis, sort: egen imp_div_market_mean = mean(implied_div_market)
by crisis, sort: egen imp_div_market_median = median(implied_div_market)
by crisis, sort: egen vol_div_market_mean = mean(vol_div_market)
by crisis, sort: egen vol_div_market_median = median(vol_div_market)
by crisis, sort: egen impvol_mean = mean(implied_vol)
by crisis, sort: egen impvol_median = median(implied_vol)
by crisis, sort: egen cds_mean = mean(cds_spread)
by crisis, sort: egen cds_median = median(cds_spread)
by crisis, sort: egen ptb_mean = mean(ptb)
by crisis, sort: egen ptb_median = median(ptb)

capture drop test_year

by crisis, sort: gen test_year = _n

br crisis vol_mean vol_median vol_div_market_mean vol_div_market_median impvol_mean impvol_median imp_div_market_mean imp_div_market_median beta_mean beta_median cds_mean cds_median if test_year == 1 & crisis != . 
br bank country vol_div_market vol_div_market_mean if crisis == 0
br ptb_mean ptb_median if test_year == 1 & crisis != . 

**** compute country yearly averages 
drop test_year
by country year, sort: egen mean_beta_c_y = mean(beta) 
by country year, sort: egen mean_vol_c_y = mean(vol)
by country year, sort: egen mean_vol_minus_market_c_y = mean(vol_minus_market)
by country year, sort: egen mean_vol_div_market_c_y = mean(vol_div_market)
by country year, sort: egen mean_implied_vol_c_y = mean(implied_vol)
by country year, sort: egen mean_implied_vol_minus_market_yc = mean(implied_minus_market)
by country year, sort: egen mean_implied_vol_div_market_yc = mean(implied_div_market)
by country year, sort: egen mean_cds_c_y = mean(cds_spread)
by country year, sort: egen mean_ptb_c_y = mean(ptb)

by year country, sort: gen test_year = _n
replace test_year = 0 if test_year != 1
br country crisis year mean_beta_c_y mean_vol_c_y mean_vol_minus_market_c_y mean_vol_div_market_c_y mean_implied_vol_c_y mean_implied_vol_minus_market_yc mean_implied_vol_div_market_yc mean_cds_c_y mean_ptb_c_y if test_year == 1 & year == 2015

br country crisis year mean_ptb_c_y if test_year == 1 & year == 2015


**** compute whole sample yearly averages and median 
by year, sort: egen beta_mean_year = mean(beta)
by year, sort: egen beta_median_year = median(beta)
by year, sort: egen vol_mean_year = mean(vol)
by year, sort: egen vol_median_year = median(vol)
by year, sort: egen imp_div_market_mean_year = mean(implied_div_market)
by year, sort: egen imp_div_market_median_year = median(implied_div_market)
by year, sort: egen vol_div_market_mean_year = mean(vol_div_market)
by year, sort: egen vol_div_market_median_year = median(vol_div_market)
by year, sort: egen impvol_mean_year = mean(implied_vol)
by year, sort: egen impvol_median_year = median(implied_vol)
by year, sort: egen cds_mean_year = mean(cds_spread)
by year, sort: egen cds_median_year = median(cds_spread)
by year, sort: egen ptb_mean_year = mean(ptb)
by year, sort: egen ptb_median_year = median(ptb)

capture drop test_year

by year, sort: gen test_year = _n

br year vol_mean_year vol_median_year vol_div_market_mean_year vol_div_market_median_year impvol_mean_year impvol_median_year imp_div_market_mean_year imp_div_market_median_year beta_mean_year beta_median_year cds_mean_year cds_median_year if test_year == 1 & year == 2015 
br year ptb_mean_year ptb_median_year if test_year == 1 & year == 2015 
